/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import java.util.ArrayList;
import java.util.Arrays;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.lib.StringLib;

class StringPacker {
    private static final int SIZEOF_SIZE_T = 4;
    private static final int SIZE_LONG = 8;

    StringPacker() {
    }

    private static boolean digit(int c) {
        return c >= 48 && c <= 57;
    }

    public static int getNum(Info info, int def) {
        if (info.position >= info.end) {
            return def;
        }
        byte c = info.string.byteAt(info.position);
        if (!StringPacker.digit(c)) {
            return def;
        }
        int result = 0;
        do {
            result = result * 10 + (c - 48);
            ++info.position;
        } while (info.position < info.end && StringPacker.digit(c = info.string.byteAt(info.position)) && result <= 0xCCCCCCB);
        return result;
    }

    public static int getNumLimit(Info info, int def) throws LuaError {
        int size = StringPacker.getNum(info, def);
        if (size <= 0 || size > 16) {
            throw new LuaError(String.format("integral size (%d) out of limits [1,16]", size));
        }
        return size;
    }

    public static Mode getOption(Info info) throws LuaError {
        byte c = info.string.byteAt(info.position++);
        return switch (c) {
            case 98 -> info.setup(1, Mode.INT);
            case 66 -> info.setup(1, Mode.UINT);
            case 104 -> info.setup(2, Mode.INT);
            case 72 -> info.setup(2, Mode.UINT);
            case 108 -> info.setup(8, Mode.INT);
            case 76 -> info.setup(8, Mode.UINT);
            case 106 -> info.setup(8, Mode.INT);
            case 74 -> info.setup(8, Mode.UINT);
            case 84 -> info.setup(4, Mode.UINT);
            case 102 -> info.setup(4, Mode.FLOAT);
            case 100 -> info.setup(8, Mode.DOUBLE);
            case 110 -> info.setup(8, Mode.DOUBLE);
            case 105 -> info.setup(StringPacker.getNumLimit(info, 4), Mode.INT);
            case 73 -> info.setup(StringPacker.getNumLimit(info, 4), Mode.UINT);
            case 115 -> info.setup(StringPacker.getNumLimit(info, 4), Mode.STRING);
            case 99 -> {
                int size = StringPacker.getNum(info, -1);
                if (size < 0) {
                    throw new LuaError("missing size for format option 'c'");
                }
                yield info.setup(size, Mode.CHAR);
            }
            case 122 -> info.setup(0, Mode.ZSTR);
            case 120 -> info.setup(1, Mode.PADDING);
            case 88 -> info.setup(0, Mode.PADD_ALIGN);
            case 32 -> info.setup(0, Mode.NONE);
            case 60, 61 -> {
                info.isLittle = true;
                yield info.setup(0, Mode.NONE);
            }
            case 62 -> {
                info.isLittle = false;
                yield info.setup(0, Mode.NONE);
            }
            case 33 -> {
                info.maxAlign = StringPacker.getNumLimit(info, 8);
                yield info.setup(0, Mode.NONE);
            }
            default -> throw new LuaError("invalid format option '" + (char)c + "'");
        };
    }

    public static Mode getDetails(Info info, int outPosition) throws LuaError {
        Mode mode = StringPacker.getOption(info);
        int align = info.size;
        if (mode == Mode.PADD_ALIGN) {
            if (info.position >= info.end || StringPacker.getOption(info) == Mode.CHAR || info.size == 0) {
                throw new LuaError("invalid next option for option 'X'");
            }
            align = info.size;
            info.size = 0;
        }
        if (align <= 1 || mode == Mode.CHAR) {
            info.alignTo = 0;
        } else {
            if (((align = Math.min(align, info.maxAlign)) & align - 1) != 0) {
                throw new LuaError("bad argument #1 to 'pack' (format asks for alignment not power of 2)");
            }
            info.alignTo = align - (outPosition & align - 1) & align - 1;
        }
        return mode;
    }

    private static void packInt(Buffer buffer, long num, boolean littleEndian, int size, boolean neg) {
        int i;
        buffer.ensure(size);
        byte[] output = buffer.output;
        int offset = buffer.offset;
        buffer.offset += size;
        for (i = 0; i < size; ++i) {
            output[offset + (littleEndian ? i : size - 1 - i)] = (byte)(num & 0xFFL);
            num >>>= 8;
        }
        if (neg && size > 8) {
            for (i = 8; i < size; ++i) {
                output[offset + (littleEndian ? i : size - 1 - i)] = -1;
            }
        }
    }

    static LuaValue pack(Varargs args) throws LuaError {
        LuaString fmt = args.arg(1).checkLuaString();
        Info info = new Info(fmt);
        Buffer buffer = new Buffer();
        int i = 2;
        while (info.position < info.end) {
            Mode mode = StringPacker.getDetails(info, buffer.offset);
            buffer.ensure(info.alignTo);
            while (info.alignTo-- > 0) {
                buffer.putUnsafe((byte)0);
            }
            switch (mode) {
                case PADD_ALIGN: 
                case NONE: {
                    break;
                }
                case INT: {
                    long limit;
                    long num = args.arg(i++).checkLong();
                    if (info.size < 8 && (-(limit = 1L << info.size * 8 - 1) > num || num >= limit)) {
                        throw ErrorFactory.argError(i - 1, "integer overflow");
                    }
                    StringPacker.packInt(buffer, num, info.isLittle, info.size, num < 0L);
                    break;
                }
                case UINT: {
                    long num = args.arg(i++).checkLong();
                    if (info.size < 8) {
                        long limit = 1L << info.size * 8;
                        if (num < 0L || num >= limit) {
                            throw ErrorFactory.argError(i - 1, "integer overflow");
                        }
                    }
                    StringPacker.packInt(buffer, num, info.isLittle, info.size, false);
                    break;
                }
                case FLOAT: {
                    float f = (float)args.arg(i++).checkDouble();
                    StringPacker.packInt(buffer, Float.floatToIntBits(f), info.isLittle, info.size, false);
                    break;
                }
                case DOUBLE: {
                    double f = args.arg(i++).checkDouble();
                    StringPacker.packInt(buffer, Double.doubleToLongBits(f), info.isLittle, info.size, false);
                    break;
                }
                case CHAR: {
                    LuaString string = args.arg(i++).checkLuaString();
                    if (string.length() > info.size) {
                        throw ErrorFactory.argError(i - 1, "string longer than given size");
                    }
                    buffer.ensure(info.size);
                    string.copyTo(buffer.output, buffer.offset);
                    buffer.offset += info.size;
                    break;
                }
                case ZSTR: {
                    LuaString string = args.arg(i++).checkLuaString();
                    int end = string.length();
                    for (int j = 0; j < end; ++j) {
                        if (string.byteAt(j) != 0) continue;
                        throw ErrorFactory.argError(i - 1, "string contains zeros");
                    }
                    buffer.ensure(string.length() + 1);
                    string.copyTo(buffer.output, buffer.offset);
                    buffer.offset += string.length() + 1;
                    break;
                }
                case STRING: {
                    LuaString string = args.arg(i++).checkLuaString();
                    if (info.size < 4 && string.length() > 1 << info.size * 8) {
                        throw ErrorFactory.argError(i - 1, "string length does not fit in given size");
                    }
                    StringPacker.packInt(buffer, string.length(), info.isLittle, info.size, false);
                    buffer.ensure(string.length());
                    string.copyTo(buffer.output, buffer.offset);
                    buffer.offset += string.length();
                    break;
                }
                case PADDING: {
                    buffer.ensure(1);
                    buffer.putUnsafe((byte)0);
                }
            }
        }
        return buffer.offset == 0 ? Constants.EMPTYSTRING : LuaString.valueOf(buffer.output, 0, buffer.offset);
    }

    static long packsize(LuaString fmt) throws LuaError {
        int size = 0;
        Info info = new Info(fmt);
        while (info.position < info.end) {
            Mode mode = StringPacker.getDetails(info, size);
            int thisSize = info.alignTo + info.size;
            if (size > Integer.MAX_VALUE - thisSize) {
                throw ErrorFactory.argError(1, "format result too large");
            }
            size += thisSize;
            if (mode != Mode.STRING && mode != Mode.ZSTR) continue;
            throw ErrorFactory.argError(1, "variable-length format");
        }
        return size;
    }

    private static long unpackInt(LuaString str, int offset, boolean isLittle, int size, boolean signed) throws LuaError {
        long res = 0L;
        int limit = Math.min(size, 8);
        for (int i = limit - 1; i >= 0; --i) {
            res <<= 8;
            res |= (long)str.charAt(offset + (isLittle ? i : size - 1 - i));
        }
        if (size < 8) {
            if (signed) {
                long mask = 1L << size * 8 - 1;
                res = (res ^ mask) - mask;
            }
        } else if (size > 8) {
            int mask = !signed || res >= 0L ? 0 : 255;
            for (int i = limit; i < size; ++i) {
                if (str.charAt(offset + (isLittle ? i : size - 1 - i)) == mask) continue;
                throw new LuaError(size + "-byte integer does not fit into Lua Integer");
            }
        }
        return res;
    }

    static Varargs unpack(Varargs args) throws LuaError {
        LuaString fmt = args.arg(1).checkLuaString();
        LuaString str = args.arg(2).checkLuaString();
        int pos = StringLib.posRelative(args.arg(3).optInteger(1), str.length()) - 1;
        if (pos > str.length() || pos < 0) {
            throw ErrorFactory.argError(3, "initial position out of string");
        }
        ArrayList<LuaValue> out = new ArrayList<LuaValue>();
        Info info = new Info(fmt);
        while (info.position < info.end) {
            Mode mode = StringPacker.getDetails(info, pos);
            if (info.alignTo + info.size + pos > str.length()) {
                throw ErrorFactory.argError(2, "data string too short");
            }
            pos += info.alignTo;
            switch (mode) {
                case PADD_ALIGN: 
                case NONE: 
                case PADDING: {
                    break;
                }
                case INT: 
                case UINT: {
                    long value = StringPacker.unpackInt(str, pos, info.isLittle, info.size, mode == Mode.INT);
                    out.add(ValueFactory.valueOf(value));
                    break;
                }
                case FLOAT: {
                    long bits = StringPacker.unpackInt(str, pos, info.isLittle, info.size, false);
                    float value = Float.intBitsToFloat((int)bits);
                    out.add(ValueFactory.valueOf(value));
                    break;
                }
                case DOUBLE: {
                    long bits = StringPacker.unpackInt(str, pos, info.isLittle, info.size, false);
                    double value = Double.longBitsToDouble(bits);
                    out.add(ValueFactory.valueOf(value));
                    break;
                }
                case CHAR: {
                    out.add(str.substringOfLen(pos, info.size));
                    break;
                }
                case STRING: {
                    long len = StringPacker.unpackInt(str, pos, info.isLittle, info.size, false);
                    if ((long)info.size + len + (long)pos > (long)str.length()) {
                        throw ErrorFactory.argError(2, "data string too short");
                    }
                    out.add(str.substringOfLen(pos + info.size, (int)len));
                    pos = (int)((long)pos + len);
                    break;
                }
                case ZSTR: {
                    int len = 0;
                    int i = pos;
                    int end = str.length();
                    while (i < end && str.charAt(i) != 0) {
                        ++i;
                        ++len;
                    }
                    out.add(str.substringOfLen(pos + info.size, len));
                    pos += len + 1;
                    break;
                }
            }
            pos += info.size;
        }
        out.add(ValueFactory.valueOf(pos + 1));
        return ValueFactory.varargsOf(out);
    }

    private static class Info {
        final LuaString string;
        int position;
        final int end;
        boolean isLittle = true;
        int maxAlign = 1;
        int size;
        int alignTo;

        public Info(LuaString string) {
            this.string = string;
            this.position = 0;
            this.end = string.length();
        }

        Mode setup(int size, Mode mode) {
            this.size = size;
            return mode;
        }
    }

    private static enum Mode {
        INT,
        UINT,
        FLOAT,
        DOUBLE,
        STRING,
        CHAR,
        PADDING,
        ZSTR,
        PADD_ALIGN,
        NONE;

    }

    private static final class Buffer {
        byte[] output;
        int offset;

        private Buffer() {
        }

        void ensure(int bytes) {
            if (this.output == null) {
                this.output = new byte[Math.max(32, bytes)];
            } else if (this.offset + bytes > this.output.length) {
                this.output = Arrays.copyOf(this.output, Math.max(this.output.length * 2, this.offset + bytes));
            }
        }

        void putUnsafe(byte value) {
            this.output[this.offset++] = value;
        }
    }
}

